package gov.va.med.mhv.usermgmt.bizobj;

import java.util.List;

import gov.va.med.mhv.usermgmt.messages.UserManagementMessages;

import org.apache.commons.lang.StringUtils;

/**
 * Business object for the Employee application entity
 *
 * Generated Skeleton Code
 */
 
public class EmployeeBO extends EmployeeBaseBO {
	
	protected void complexValidation() {
		validateUniqueUser();
	}

	private void validateUniqueUser() {
		
		//if ID exists, this is not a new entity, so allow update to take place.
		if( getId() != null ) {
			return;
		}
		
		String userName = StringUtils.lowerCase( getUserName() );
		List results = EmployeeBO.getEmployeeByUserName(userName);

		//if valid results found, user by this name already exists, so this is an error
		if (results != null && results.size() > 0 && !((EmployeeBO)results.get(0)).getAllMessages().hasErrorMessages()){
			addError( UserManagementMessages.USER_ALREADY_EXISTS, new String[] { userName } );
		}
	}
}